% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSDTest.R
\name{LSDTest}
\alias{LSDTest}
\title{Least Significant Difference (LSD) Test v2.0}
\usage{
LSDTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default 0.05).}
}
\value{
An object of class \code{"lsd"} and \code{"comparaciones"} containing:
\itemize{
  \item \code{Resultados}: a data.frame with columns \code{Comparacion}, \code{Diferencia}, \code{SE}, \code{t_value},
        \code{p_value} (unadjusted), \code{p_ajustada} (LSD), \code{Valor_Critico} (critical difference), and \code{Significancia}.
  \item \code{Promedios}: a named vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: group names ordered from highest to lowest mean.
  \item \code{Metodo}: "LSD t-test".
  \item \code{Termino}: the term being compared (e.g., "A", "B", or "A:B").
  \item \code{MSerror}, \code{df_error}, \code{N}: useful for plots with error bars.
}
}
\description{
Performs unadjusted pairwise t-tests following a significant ANOVA.
}
\details{
Advantages:
- Very powerful when assumptions are met.
- Simple and easy to interpret.

Disadvantages:
- High risk of Type I error without correction.
- Not recommended if many comparisons are made.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- LSDTest(mod)
summary(resultado)
plot(resultado)

# RCBD
mod <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res <- LSDTest(mod, comparar = "as.factor(labor)")
summary(res); plot(res)                      # plot usara p_value

# Factorial
mod2 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
resAB <- LSDTest(mod2, comparar = c("as.factor(labor)","Sexo"))
summary(resAB, n = Inf); plot(resAB, horizontal = TRUE)

}
\references{
Fisher, R. A. (1935). The Design of Experiments. Oliver & Boyd.
}
