% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecialDefs.R
\name{SpecialDefs}
\alias{SpecialDefs}
\alias{AddSpecialDefs}
\alias{RemoveSpecialDefs}
\title{Add or remove species definitions}
\usage{
AddSpecialDefs(ThisProblem, Value, SpecialDef, DoCheck = TRUE)

RemoveSpecialDefs(ThisProblem, SpecialDefToRemove, Index = 1, DoCheck = TRUE)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{Value}{A character vector. When `SpecialDef` is either `"BL"` or
`"Metal"`, this should be the name of a component in
`ThisProblem$Chem$Name`. When `SpecialDef` is `"BL-Metal"`, this should be
the name of a chemical species in `ThisProblem$Spec$Name`. When
`SpecialDef` is `"WHAM"`, this should be either a supported WHAM version
number (i.e., one of `"V"`, `"VI"`, or `"VII"`), or the file path to a WHAM
parameters file (.wdat file) that follows the format of one of the standard
versions supplied with this package (see
`system.file("extdata/WHAM/WHAM_V.wdat", package = "BLMEngineInR")` for an
example).}

\item{SpecialDef}{A character vector indicating which special definition to
add a value for. Valid values are `"BL"`, `"Metal"`, `"BL-Metal"`,
`"BLMetal"` (same as `"BL-Metal"`), and `"WHAM"`.}

\item{DoCheck}{A logical value indicating whether checks should be performed
on the incoming and outgoing problem objects. Defaults to `TRUE`, as you
usually want to make sure something isn't awry, but the value is often set
to `FALSE` when used internally (like in DefineProblem) so the problem is
only checked once at the end.}

\item{SpecialDefToRemove}{The name of the special definition to remove.}

\item{Index}{If applicable (such as if there are two BL-Metal species), the
index of which to remove (i.e., the first one or second one).}
}
\value{
`ThisProblem`, with the special definitions changed.
}
\description{
The special definitions in a parameter file include indicating
  the biotic ligand species relevant to toxicity ("BL"), the toxic metal
  ("Metal"), the species responsible for the critical accumulation associated
  with toxicity at the biotic ligand ("BL-Metal"), and the model version of
  the Windemere Humic Aqueous Model to use to represent organic matter
  binding ("WHAM").
}
\examples{
print(carbonate_system_problem[c("BL","Metal","BLMetal","WHAM")])
my_new_problem = carbonate_system_problem
my_new_problem = AddInComps(ThisProblem = my_new_problem, InCompName = "Cu",
                            InCompCharge = 2,
                            InCompMCName = "Water",
                            InCompType = "MassBal",
                            InCompActCorr = "Debye")
my_new_problem = AddSpecialDefs(ThisProblem = my_new_problem,
                                Value = "Cu",
                                SpecialDef = "Metal")
print(my_new_problem[c("BL","Metal","BLMetal","WHAM")])
my_new_problem = RemoveSpecialDefs(ThisProblem = my_new_problem,
                                   SpecialDefToRemove = "Metal")
print(my_new_problem[c("BL","Metal","BLMetal","WHAM")])
}
\seealso{
Other problem manipulation functions: 
\code{\link{BlankProblem}()},
\code{\link{Components}},
\code{\link{CriticalValues}},
\code{\link{InLabs}},
\code{\link{InVars}},
\code{\link{MassCompartments}},
\code{\link{Phases}},
\code{\link{Species}}
}
\concept{problem manipulation functions}
