% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_endpoint.R
\name{get_oc_binary}
\alias{get_oc_binary}
\title{Operating characteristics for binary Endpoint}
\usage{
get_oc_binary(p, n, nsim, fb, sb, seed = NULL)
}
\arguments{
\item{p}{Response rate}

\item{n}{A numeric vector representing the additional patients enrolled at each interim analysis.
The value at index \code{i} indicates the number of new patients added at interim analysis \code{i}. 
The total sample size at interim \code{i} is the cumulative sum of the values in \code{n} up to that index. 
For example, for four interim analyses with total sample sizes of 10, 15, 20, and 30, 
the vector would be represented as \code{n = c(10, 5, 5, 10)}, where:
\itemize{
  \item 10 is the number of patients enrolled at interim 1,
  \item 5 (15 - 10) is the additional number of patients enrolled at interim 2,
  \item 5 (20 - 15) is the additional number of patients enrolled at interim 3,
  \item 10 (30 - 20) is the additional number of patients enrolled at interim 4.
}}

\item{nsim}{number of simulation}

\item{fb}{vector/matrix of futility boundary at each interim analysis specified 
in the following order: c(f_1,..., f_length(n))}

\item{sb}{vector/matrix  of superiority boundary at each interim analysis specified 
in the following order: c(s_1,..., s_length(n))}

\item{seed}{for reproducibility}
}
\value{
A data frame with the following columns
\describe{
\item{lambda: }{lambda values for cut-off probability}
\item{gamma: }{gamma values for cut-off probability}
\item{eta: }{eta values for cut-off probability}
\item{earlystopfuti_mean: }{Average number of early stopping due to futility}
 \item{earlystopsupe_mean: }{Average number of early stopping for futility due to efficacy}
  \item{ss_mean: }{Average sample size} 
  \item{rejectnull_mean: }{Average number of hypothesis rejection at the final analysis (aka Type-I error 
  if the response rate is the null rate or Power if the response rate is the alternative rate.} 
  \item{earlystopfuti_sum: }{Total number of early stopping due to futility} 
  \item{earlystopsupe_sum: }{Total number of early early stopping due to efficacy} 
  \item{ss_sum: }{Sum of sample sizes across simulation} 
  \item{rejectnull_sum: }{Total number of hypothesis rejection at the final analysis} 
  }
}
\description{
Operating characteristics for binary Endpoint
}
\examples{
 H0 <- 0.2
 a1 <- H0
 b1 <- 1-a1
 seed <- 123
 n <- c(10, 5, 5)
 method <- "power"
 boundary_tab<- get_boundary_binary(H0=H0, a1=a1, b1=b1, n =n,
                               lambda = seq(0, 1, l = 11),
                               gamma  = seq(0, 1, l = 11),
                               eta    = seq(0, 3, l = 31),
                               method = method,
                               seed=seed)
test_oc<-get_oc_binary(
  p = 0.2,
  n = c(10, 5, 5),
  nsim = 1000,
  fb = boundary_tab$cnf,
  sb = boundary_tab$cns,
  seed = seed
)
  
}
