% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcIntegralSurv2_cpp}
\alias{calcIntegralSurv2_cpp}
\title{C++ Function pre-computing the Integral Terms for the Peron Method in the survival case.}
\usage{
calcIntegralSurv2_cpp(
  time,
  survival,
  dSurvival,
  index_survival,
  index_dSurvival1,
  index_dSurvival2,
  lastSurv,
  lastdSurv,
  iidNuisance,
  nJump
)
}
\arguments{
\item{time}{[numeric vector] vector of jump time for S2.}

\item{survival}{[numeric vector] the survival at each jump time: \eqn{S1(t+\tau)}.}

\item{dSurvival}{[numeric vector] the jump in survival at each jump time: \eqn{S2(t+)-S2(t-)}}

\item{index_survival}{[numeric vector] the position of survival parameter \eqn{S1(t+\tau)} among all parameters relative to S1.}

\item{index_dSurvival1}{[numeric vector] the position of survival parameter \eqn{S2(t-)} among all parameters relative to S2.}

\item{index_dSurvival2}{[numeric vector] the position of survival parameter \eqn{S2(t+)} among all parameters relative to S2.}

\item{lastSurv}{[numeric] the value of S2 at the end of the follow-up.}

\item{iidNuisance}{[logical] should the derivative of the integral relative to the S1 and S2 parameter be output.}

\item{nJump}{[integer] the number of jump times relative to S2.}
}
\description{
Compute the integral with respect to the jump in survival for pairs where both outcomes are censored, i.e. \eqn{\int S1(t+\tau) dS2(t)}.
}
\author{
Brice Ozenne
}
\keyword{Cpp}
\keyword{function}
\keyword{internal}
