% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_tidyhydat_ECDE_meta.R
\name{ch_tidyhydat_ECDE_meta}
\alias{ch_tidyhydat_ECDE_meta}
\title{Creates an ECDE-like dataframe of metadata from \pkg{tidyhydat}}
\usage{
ch_tidyhydat_ECDE_meta(stations, all_ECDE = FALSE)
}
\arguments{
\item{stations}{A vector of WSC station IDs, i.e. \code{c("05BB001", "05BB003", "05BB004", 
"05BB005")}. If \code{stations = "all"} then values are returned for all stations. Note
that you should ensure that that the \pkg{tidyhydat} database is up to date, if you
select  \code{stations = "all"}, so that the most recent set of stations is used.}

\item{all_ECDE}{Should all ECDE values be returned? If \code{FALSE} the default, then
values of \code{Flow}, \code{Level}, \code{Sed}, \code{OperSched}, \code{Region}, \code{Datum}, and
\code{Operator} are omitted or will differ from the ECDE values. If \code{all_ECDE = TRUE},
then the function will return values identical to ECDE. Note that setting 
\code{all_ECDE = TRUE} will result in very long execution times, as it is necessary
to extract many daily values for each station to determine the values of 
\code{Flow}, \code{Level}, \code{Sed}, and \code{OperSched} to determine the
final values.}
}
\value{
Returns a list with three items:
\itemize{
\item {\code{meta} - a dataframe of metadata from \pkg{tidyhydat} in ECDE form (not all ECDE fields are reproduced in this summary)}
\item {\code{H_version} - version information, and }
\item {\code{th_meta} - a dataframe with all \pkg{tidyhdat} fields including:}
\itemize{
  \item {Station - StationID}
  \item {StationName - Station Name}
  \item {HYDStatus - Active or Discontinued}
  \item {Prov - Province}
  \item {Latitude}
  \item {Longitude}
  \item {DrainageArea - km\eqn{^2}{^2}}
  \item {Years - number of years with data}
  \item {From - Start Year}
  \item {To - End Year}
  \item {Reg. - Regulated?}
  \item {Flow - not captured (differs from ECDE), unless \code{all_ECDE = TRUE}}
  \item {Level - not captured (differs from ECDE), unless \code{all_ECDE = TRUE}}
  \item {Sed - not captured (differs from ECDE), unless \code{all_ECDE = TRUE}}
  \item {OperSched - not captured (differs from ECDE), unless \code{all_ECDE = TRUE}}
  \item {RealTime - if TRUE/Yes}
  \item {RHBN - if TRUE/Yes is in the reference hydrologic basin network}
  \item {Region - number of region instead of name (differs from ECDE), unless \code{all_ECDE = TRUE}}
  \item {Datum - reference number (differs from ECDE), unless \code{all_ECDE = TRUE}}
  \item {Operator - reference number (differs from ECDE), unless \code{all_ECDE = TRUE}}
  }
}
}
\description{
Extracts tombstone (meta) data for stations from \pkg{tidyhydat} in a 
format similar to that used by the Environment Canada Data Explorer (ECDE). The 
default does not capture all the fields in ECDE, which includes the most recent status 
of many fields such as operating schedule. Returning these values slows the function,
particularly when all WSC stations are selected.
}
\examples{
# This example uses the built-in test database, by setting the hydat_path parameter
# You will want to use it with your actual HYDAT database
library(tidyhydat)
# check for existence of test database
test_db <- hy_test_db()
if (file.exists(test_db)) {
  stations <- c("05AA008", "08MF005", "05HD008")
  hy_set_default_db(test_db)
  result <- ch_tidyhydat_ECDE_meta(stations)
  metadata <- result[[1]]
  version <- result[[2]]
  hy_set_default_db(NULL)    # Reset HYDAT database
}
\dontrun{
# This example is not run, as it will take several hours to execute and will
# return many warnings for stations having no data. Note that it is using the actual
# HYDAT database, which must have been installed previously
# This use of the function is intended for the package maintainers to 
# update the HYDAT_list data frame
result <- ch_tidyhydat_ECDE_meta("all", TRUE)
HYDAT_list <- result$meta
}

}
\seealso{
\code{\link{ch_get_ECDE_metadata}} \code{\link{ch_tidyhydat_ECDE}}
}
\author{
Paul Whitfield, Kevin Shook
}
