% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCharacterization.R
\name{createCharacterizationSettings}
\alias{createCharacterizationSettings}
\title{Create the settings for a large scale characterization study}
\usage{
createCharacterizationSettings(
  timeToEventSettings = NULL,
  dechallengeRechallengeSettings = NULL,
  aggregateCovariateSettings = NULL
)
}
\arguments{
\item{timeToEventSettings}{A list of timeToEvent settings}

\item{dechallengeRechallengeSettings}{A list of dechallengeRechallenge settings}

\item{aggregateCovariateSettings}{A list of aggregateCovariate settings}
}
\value{
Returns the connection to the sqlite database
}
\description{
This function creates a list of settings for different characterization studies
}
\details{
Specify one or more timeToEvent, dechallengeRechallenge and aggregateCovariate settings
}
\examples{
# example code

drSet <- createDechallengeRechallengeSettings(
  targetIds = c(1,2),
  outcomeIds = 3
)

cSet <- createCharacterizationSettings(
  dechallengeRechallengeSettings = drSet
)

}
\seealso{
Other LargeScale: 
\code{\link{loadCharacterizationSettings}()},
\code{\link{runCharacterizationAnalyses}()},
\code{\link{saveCharacterizationSettings}()}
}
\concept{LargeScale}
