% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NegativeControlCohorts.R
\name{generateNegativeControlOutcomeCohorts}
\alias{generateNegativeControlOutcomeCohorts}
\title{Generate a set of negative control outcome cohorts}
\usage{
generateNegativeControlOutcomeCohorts(
  connectionDetails = NULL,
  connection = NULL,
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortDatabaseSchema = cdmDatabaseSchema,
  cohortTable = getCohortTableNames()$cohortTable,
  negativeControlOutcomeCohortSet,
  occurrenceType = "all",
  incremental = FALSE,
  incrementalFolder = NULL,
  detectOnDescendants = FALSE
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cdmDatabaseSchema}{Schema name where your patient-level data in OMOP CDM format resides.
Note that for SQL Server, this should include both the database and
schema name, for example 'cdm_data.dbo'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTable}{Name of the cohort table.}

\item{negativeControlOutcomeCohortSet}{The \code{negativeControlOutcomeCohortSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{outcomeConceptId}{The concept_id in the condition domain to use for the negative control outcome.}}}

\item{occurrenceType}{The occurrenceType will detect either: the first time an outcomeConceptId occurs
or all times the outcomeConceptId occurs for a person. Values accepted: 'all' or 'first'.}

\item{incremental}{Create only cohorts that haven't been created before?}

\item{incrementalFolder}{If \code{incremental = TRUE}, specify a folder where records are
kept of which definition has been executed.}

\item{detectOnDescendants}{When set to TRUE, detectOnDescendants will use the vocabulary to find negative control
outcomes using the outcomeConceptId and all descendants via the concept_ancestor table.
When FALSE, only the exact outcomeConceptId will be used to detect the outcome.}
}
\value{
Invisibly returns an empty negative control outcome cohort set data.frame
}
\description{
This function generate a set of negative control outcome cohorts.
For more information please see [Chapter 12 - Population Level Estimation](https://ohdsi.github.io/TheBookOfOhdsi/PopulationLevelEstimation.html)
for more information how these cohorts are utilized in a study design.
}
