% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_humidity_calcs.R
\name{add_humidity_calcs}
\alias{add_humidity_calcs}
\title{Add Humidity calculations}
\usage{
add_humidity_calcs(mydata, Temp = "Temp", RH = "RH", P_atm = 1013.25, ...)
}
\arguments{
\item{mydata}{A dataframe containing temperature and relative humidity data.}

\item{Temp}{Character string name of the temperature column (default "Temp").}

\item{RH}{Character string name of the relative humidity column (default "RH").}

\item{P_atm}{Atmospheric pressure (hPa), default 1013.25.}

\item{...}{Additional parameters passed to humidity calculation functions.}
}
\value{
The input dataframe augmented with columns for vapor pressure, dew point, absolute humidity,
  air density, mixing ratio, specific humidity, and enthalpy.

\describe{
  \item{Pws}{Saturated vapour pressure at given temperature (hPa).}
  \item{Pw}{Partial pressure of water vapour present (hPa).}
  \item{DP}{Dew Point, condensation temperature based on RH (°C).}
  \item{AH}{Mass of water vapour per air volume (g/m³).}
  \item{AD}{Moist air density (kg/m³).}
  \item{MR}{Ratio of water vapour to dry air mass (g/kg).}
  \item{SH}{Ratio of water vapour to total air mass (g/kg).}
  \item{Enthalpy}{Total enthalpy, h, of air-vapour mixture (kJ/kg).}
}
}
\description{
This function adds several humidity variables
to a dataframe with temperature and relative humidity columns.
It uses the humidity functions (e.g., calcPws, calcPw).
}
\examples{

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> add_humidity_calcs() |> dplyr::glimpse()


}
\seealso{
\code{\link{calcPws}} for `Pws`

\code{\link{calcPw}} for `Pw`

\code{\link{calcDP}} for `DP`

\code{\link{calcAH}} for `AH`

\code{\link{calcAD}} for `AD`

\code{\link{calcMR}} for `MR`

\code{\link{calcSH}} for `SH`

\code{\link{calcEnthalpy}} for `Enthalpy`
}
