% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskQuarto.R
\name{renderTaskQmd}
\alias{renderTaskQmd}
\title{Render the task from the Qmd file}
\usage{
renderTaskQmd(task, output_format = "docx", debug = FALSE, suffix = NA, ...)
}
\arguments{
\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{output_format}{Target output format (defaults to \code{"html"}). The option
\code{"all"} will render all formats defined within the file or project.}

\item{debug}{if TRUE execute in the global environment.}

\item{suffix}{Filename suffix, used to develop scripts for sub-analyses for a given task, default NA.}

\item{...}{
  Arguments passed on to \code{\link[quarto:quarto_render]{quarto::quarto_render}}
  \describe{
    \item{\code{input}}{The input file or project directory to be rendered (defaults
to rendering the project in the current working directory).}
    \item{\code{output_file}}{Base name for single-file output (e.g. PDF, ePub, MS Word).
This sets the \code{output-file} Quarto metadata. If \code{NULL}, the output filename
will be based on the input filename.}
    \item{\code{execute}}{Whether to execute embedded code chunks.}
    \item{\code{execute_params}}{A list of named parameters that override custom params
specified within the YAML front-matter.}
    \item{\code{execute_dir}}{The working directory in which to execute embedded code
chunks.}
    \item{\code{execute_daemon}}{Keep Jupyter kernel alive (defaults to 300 seconds).
Note this option is only applicable for rendering Jupyter notebooks or
Jupyter markdown.}
    \item{\code{execute_daemon_restart}}{Restart keepalive Jupyter kernel before render.
Note this option is only applicable for rendering Jupyter notebooks or
Jupyter markdown.}
    \item{\code{execute_debug}}{Show debug output for Jupyter kernel.}
    \item{\code{use_freezer}}{Force use of frozen computations for an incremental
file render.}
    \item{\code{cache}}{Cache execution output (uses knitr cache and jupyter-cache
respectively for Rmd and Jupyter input files).}
    \item{\code{cache_refresh}}{Force refresh of execution cache.}
    \item{\code{metadata}}{An optional named list used to override YAML
metadata. It will be passed as a YAML file to \code{--metadata-file} CLI flag.
This will be merged over \code{metadata-file} options if both are
specified.}
    \item{\code{metadata_file}}{A yaml file passed to \code{--metadata-file} CLI flags to
override metadata. This will be merged with \code{metadata} if both are
specified, with low precedence on \code{metadata} options.}
    \item{\code{quiet}}{Suppress warning and other messages, from R and also Quarto CLI
(i.e \code{--quiet} is passed as command line).

\code{quarto.quiet} \R option or \code{R_QUARTO_QUIET} environment variable can be used to globally override a function call
(This can be useful to debug tool that calls \verb{quarto_*} functions directly).

On Github Actions, it will always be \code{quiet = FALSE}.}
    \item{\code{profile}}{\href{https://quarto.org/docs/projects/profiles.html}{Quarto project profile(s)} to use. Either
a character vector of profile names or \code{NULL} to use the default profile.}
    \item{\code{quarto_args}}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}
    \item{\code{pandoc_args}}{Additional command line arguments to pass on to Pandoc.}
    \item{\code{as_job}}{Render as an RStudio background job. Default is \code{"auto"},
which will render individual documents normally and projects as
background jobs. Use the \code{quarto.render_as_job} \R option to control
the default globally.}
  }}
}
\value{
the file name invisibly.
}
\description{
The template of the task is rendered towards pdf or html in the documentation directory of the specified task.
Note that on windows, Gnu zip may be required. The path to the executable must be added to the environment variables.
}
