library(testthat)
library(data.table)


mock_plan <- data.table(
  step = 1:3,
  operation = c("AGGREGATE", "MERGE", "SELECT"),
  target = c("agg_transactions", "merged_step_2", "final_data"),
  details = c("Aggregate 'transactions'", "Merge 'customers' with 'agg_transactions'", "Select final columns"),
  code = c(
    "agg_transactions <- transactions[, .(RevenueByCustomer = sum(revenue)), by = .(customer_id)]",
    "merged_step_2 <- merge(x = customers, y = agg_transactions, by = c('customer_id'), all.x = TRUE)",
    "final_data <- merged_step_2[, .SD, .SDcols = c('customer_id', 'region', 'RevenueByCustomer')]"
  )
)

mock_data_list <- list(
  customers = data.table(customer_id = c("c1", "c2"), region = c("NA", "EU")),
  transactions = data.table(customer_id = c("c1", "c1", "c2"), revenue = c(10, 20, 50))
)
test_that("plot_join_plan returns a DiagrammeR object for a valid plan", {
  skip_if_not_installed("DiagrammeR")
  
  plot_output <- plot_join_plan(mock_plan)
  
  expect_s3_class(plot_output, "grViz")
  expect_s3_class(plot_output, "htmlwidget")
})

test_that("plot_join_plan stops if DiagrammeR is not installed", {

    expect_error(
    plot_join_plan("not a data.table"),
    "'join_plan' must be a data.table"
  )
})

test_that("plot_join_plan validates the input plan structure", {
  
  invalid_plan <- data.table(step = 1, wrong_col_name = "AGGREGATE")
  
  expect_error(
    plot_join_plan(invalid_plan),
    "must be a data.table generated by create_join_plan()"
  )
})