% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a-misc.R
\name{make.clip.poly}
\alias{make.clip.poly}
\alias{make.clip.poly,matrix-method}
\title{Make clipping polygon from bbox}
\usage{
\S4method{make.clip.poly}{matrix}(bbox, crs)
}
\arguments{
\item{bbox}{2x2 matrix}

\item{crs}{CRS object defining the projection of the SpatialPolygons object
to be clipped}
}
\value{
\code{SpatialPolygons} object
}
\description{
Makes a polygon from a bounding box to use for
clipping the coastline, or other SpatialPolygons objects
}
\examples{
data(bathymetry)
bbox <- cbind("min"=c(549517, 6155000), "max"=c(636000, 6210000))
rownames(bbox) <- c("x", "y")
clip.poly <- make.clip.poly(bbox, crs(bathymetry))
}
\seealso{
\code{\link{bbox}} for creation of bbox matrix from DeponsRaster
}
