% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R, R/priors.R, R/s3_funcs.R
\name{mapped_pars}
\alias{mapped_pars}
\alias{mapped_pars.emc.design}
\alias{mapped_pars.emc.prior}
\alias{mapped_pars.emc}
\title{Parameter Mapping Back to the Design Factors}
\usage{
mapped_pars(
  x,
  p_vector = NULL,
  model = NULL,
  digits = 3,
  remove_subjects = TRUE,
  covariates = NULL,
  ...
)

\method{mapped_pars}{emc.design}(
  x,
  p_vector = NULL,
  model = NULL,
  digits = 3,
  remove_subjects = TRUE,
  covariates = NULL,
  ...
)

\method{mapped_pars}{emc.prior}(
  x,
  p_vector = NULL,
  model = NULL,
  digits = 3,
  remove_subjects = TRUE,
  covariates = NULL,
  ...
)

\method{mapped_pars}{emc}(
  x,
  p_vector = NULL,
  model = NULL,
  digits = 3,
  remove_subjects = TRUE,
  covariates = NULL,
  ...
)
}
\arguments{
\item{x}{an \code{emc}, \code{emc.prior} or \code{emc.design} object}

\item{p_vector}{Optional. Specify parameter vector to get numeric mappings.
Must be in the form of \code{sampled_pars(design)}}

\item{model}{Optional model type (if not already specified in \code{design})}

\item{digits}{Integer. Will round the output parameter values to this many decimals}

\item{remove_subjects}{Boolean. Whether to include subjects as a factor in the design}

\item{covariates}{Covariates specified in the design can be included here.}

\item{...}{optional arguments}
}
\value{
Matrix with a column for each factor in the design and for   each model parameter type (\code{p_type}).
}
\description{
Maps parameters of the cognitive model back to the experimental design. If p_vector
is left unspecified will print a textual description of the mapping.
Otherwise the p_vector can be created using \code{sampled_pars()}.
The returned matrix shows whether/how parameters
differ across the experimental factors.
}
\examples{
# First define a design:
design_DDMaE <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
mapped_pars(design_DDMaE)
# Then create a p_vector:
p_vector=c(v_Sleft=-2,v_Sright=2,a=log(1),a_Eneutral=log(1.5),a_Eaccuracy=log(2),
          t0=log(.2),Z=qnorm(.5),sv=log(.5),SZ=qnorm(.5))
# This will map the parameters of the p_vector back to the design
mapped_pars(design_DDMaE, p_vector)

}
