% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_hsd.R
\name{FDOTT_HSD}
\alias{FDOTT_HSD}
\title{Test multiple linear relationships between probability vectors in factorial designs}
\usage{
FDOTT_HSD(test, weights = NULL, group.sizes = TRUE)
}
\arguments{
\item{test}{a \code{FDOTT} object, i.e., output of \code{\link{FDOTT}}.}

\item{weights}{weight vector of length \eqn{K}. \code{weights = NULL} means that no weights are used. For \code{weights = TRUE} the standard weighting is used.}

\item{group.sizes}{integer vector summing to the number of comparisons \eqn{M}. Used to split the null hypothesis into sub-hypotheses of the
specified sizes. The default \code{group.sizes = TRUE} extracts these sizes from \code{test}. For \code{group.sizes = NULL}, each equation is its own group.}
}
\value{
A \code{FDOTT_HSD} object containing:
\tabular{ll}{
\code{p.value}      \tab the \eqn{p}-values \cr
\code{statistic}    \tab the values of the test statistics \cr
\code{null.samples} \tab samples drawn from the null distribution \cr
}
}
\description{
Perform an optimal transport based HSD test to deal with multiple comparisons simultaneously.
}
\details{
Let \eqn{H_0^L : L\mu = 0} be the null hypothesis of \code{test}. In the case of rejection, it is of interest to
find out exactly which row-equations are not satisfied with statistical significance. To this end, \eqn{L\mu = 0} can be split into
a number of sub-hypotheses which are tested simultaneously via an approach inspired by Tukey's HSD test, see Groppe et al. (2025) for more details.
}
\examples{

# see FDOTT for more examples

# enable parallel computation
if (requireNamespace("future")) {
    future::plan(future::multisession)
}

K <- 3
N <- 2
costm <- cost_matrix_lp(1:N)

# use higher number to better approximate null distribution and get more accurate p-value
num.sim <- 10

# underlying probability vectors (one-way layout)
# only mu^1 and mu^3 are equal
mu <- matrix(0.5, K, N, TRUE)
mu[2, ] <- c(0.2, 0.8)

n <- c(300, 360, 200)

set.seed(123)
samples <- tab_sample(n, mu)
res <- FDOTT(samples, costm, num.sim = num.sim) |> FDOTT_HSD()
# significant differences for mu^1 = mu^2 and mu^2 = mu^3
print(res)
\dontshow{
## R CMD check: make sure any open connections are closed afterward
if (requireNamespace("future") && !inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
\references{
M. Groppe, L. Niemöller, S. Hundrieser, D. Ventzke, A. Blob, S. Köster and A. Munk (2025). Optimal Transport Based Testing in Factorial Design.
arXiv preprint. \doi{10.48550/arXiv.2509.13970}.
}
\seealso{
\code{\link{FDOTT}}
}
