% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPC.R
\name{OPC}
\alias{OPC}
\title{Apply the OPC method to the Laplace factor model}
\usage{
OPC(data, m, eta)
}
\arguments{
\item{data}{is a highly correlated online data set}

\item{m}{is the number of principal component}

\item{eta}{is the proportion of online data to total data}
}
\value{
Ao,Do
}
\description{
This function computes Online Principal Component Analysis (OPC) for the provided input data, estimating factor loadings and uniquenesses. It calculates mean squared errors and sparsity for the estimated values compared to true values.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- OPC(data, m, eta=0.1)
print(results)
}
