% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_estimation.R
\name{mcee_helper_stage2_estimate_mcee}
\alias{mcee_helper_stage2_estimate_mcee}
\title{Stage-2 MCEE parameter estimation given nuisance predictions}
\usage{
mcee_helper_stage2_estimate_mcee(
  data,
  id_var,
  dp_var,
  outcome_var,
  treatment_var,
  avail_var = NULL,
  p1,
  p0,
  q1,
  q0,
  eta1,
  eta0,
  mu1,
  mu0,
  nu1,
  nu0,
  omega_nrows,
  f_nrows
)
}
\arguments{
\item{data}{Data frame in long format.}

\item{id_var, dp_var, outcome_var, treatment_var, avail_var}{Character column names.}

\item{p1, p0, q1, q0, eta1, eta0, mu1, mu0, nu1, nu0}{Numeric vectors of length \code{nrow(data)}
containing Stage-1 nuisance predictions for each row.}

\item{omega_nrows}{Numeric vector of length \code{nrow(data)} containing per-row
weights \eqn{\omega(i,t) \geq 0}.}

\item{f_nrows}{Numeric matrix with \code{nrow(data)} rows and \code{p} columns
containing the basis functions \eqn{f(t)} evaluated at each decision point.}
}
\value{
List containing MCEE parameter estimates and inference:
\describe{
  \item{\code{alpha_hat}}{Vector of length \code{p}: NDEE parameter estimates}
  \item{\code{alpha_se}}{Vector of length \code{p}: NDEE standard errors}
  \item{\code{beta_hat}}{Vector of length \code{p}: NIEE parameter estimates}
  \item{\code{beta_se}}{Vector of length \code{p}: NIEE standard errors}
  \item{\code{varcov}}{Matrix \eqn{2p \times 2p}: Joint variance-covariance for \eqn{(\alpha,\beta)}}
  \item{\code{alpha_varcov}}{Matrix \eqn{p \times p}: Variance-covariance for \eqn{\alpha}}
  \item{\code{beta_varcov}}{Matrix \eqn{p \times p}: Variance-covariance for \eqn{\beta}}
}
}
\description{
Computes the Natural Direct Excursion Effect (NDEE; \eqn{\alpha}) and Natural Indirect
Excursion Effect (NIEE; \eqn{\beta}) parameters using Stage-1 nuisance predictions.
This is Stage 2 of the two-stage MCEE procedure.
}
\details{
**MCEE Estimating Equations:**
The function constructs influence functions \eqn{\phi_t^{11}}, \eqn{\phi_t^{10}}, \eqn{\phi_t^{00}} for each row and
solves the estimating equations:
\itemize{
  \item **NDEE (\eqn{\alpha})**: \eqn{\sum_{i,t}\omega(i,t) [\phi_t^{10} - \phi_t^{00}] f(t) = 0}
  \item **NIEE (\eqn{\beta})**: \eqn{\sum_{i,t}\omega(i,t) [\phi_t^{11} - \phi_t^{10}] f(t) = 0}
}

**Influence Functions:**
- \eqn{\phi_t^{11}}: Direct effect pathway influence function
- \eqn{\phi_t^{10}}: Mediated effect pathway influence function
- \eqn{\phi_t^{00}}: Control/reference pathway influence function

**Variance Estimation:**
Uses sandwich variance estimation with subject-level clustering. The variance
accounts for the two-stage estimation uncertainty.
}
