% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.dcee.R
\name{summary.dcee_fit}
\alias{summary.dcee_fit}
\title{Summary for DCEE fits}
\usage{
\method{summary}{dcee_fit}(
  object,
  lincomb = NULL,
  conf_level = 0.95,
  show_control_fit = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"dcee_fit"} returned by [dcee()].}

\item{lincomb}{Optional numeric vector or matrix specifying linear
combinations \eqn{L \beta}. If a vector of length \eqn{p} (number of betas),
a single linear combination is evaluated. If a matrix, it must have \eqn{p}
columns; each row defines one combination. Row names (if present) are used
as labels.}

\item{conf_level}{Confidence level for intervals (default \code{0.95}).}

\item{show_control_fit}{Logical; if \code{TRUE}, include compact information about
the Stage-1 nuisance regressions (if available). When \code{cross_fit = TRUE}
in [dcee()], \code{regfit_a0}/\code{regfit_a1} refer to the \emph{last fold}
fit and are provided for inspection only.}

\item{...}{Currently ignored.}
}
\value{
A list of class \code{"summary.dcee_fit"} with components:
\itemize{
  \item \code{call} — the original call
  \item \code{df} — degrees of freedom used for t-tests (may be \code{NA})
  \item \code{conf_level} — the confidence level
  \item \code{excursion_effect} — data frame with coefficient table for \eqn{\beta}
  \item \code{lincomb} — optional data frame with linear-combination results
  \item \code{control_fit} — optional list describing Stage-1 fits (only if \code{show_control_fit})
}
}
\description{
Produce inference tables for distal causal excursion effects from a
[dcee()] model. By default uses small-sample \eqn{t}-tests with
\code{df = object$df} (subjects minus number of betas). If \code{df}
is missing or nonpositive, falls back to large-sample normal (z) inference.
}
