% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_diagnostic_plot.R
\name{univariate_diagnostic_plot}
\alias{univariate_diagnostic_plot}
\title{Diagnostic Plots for Univariate and Multivariate Data}
\usage{
univariate_diagnostic_plot(
  data,
  type = c("qq", "histogram", "boxplot", "scatter"),
  title = NULL,
  interactive = FALSE
)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame with observations in rows and variables in columns.}

\item{type}{Character; type of plot. One of: "qq", "histogram", "boxplot", "scatter". Default selects the first.}

\item{title}{Character; plot title.}

\item{interactive}{Logical; if TRUE, renders the plot interactively using plotly.}
}
\description{
Generates QQ plots, histograms with density overlays, boxplots, or scatterplot matrices
for numeric data (vector, matrix, or data frame).
}
\examples{
\dontrun{
data <- iris[1:50, 1:3]
univariate_diagnostic_plot(data, type = "histogram")
univariate_diagnostic_plot(data, type = "qq")
univariate_diagnostic_plot(data, type = "boxplot")
univariate_diagnostic_plot(data, type = "scatter", interactive = TRUE)
}
}
