% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradients.R
\name{safe_integrate}
\alias{safe_integrate}
\title{Safe integration wrapper with multiple fallback strategies}
\usage{
safe_integrate(
  integrand_func,
  lower = 1e-08,
  upper = 50,
  max_attempts = 3,
  ...
)
}
\arguments{
\item{integrand_func}{Function to integrate. Must accept a numeric vector
as input and return numeric values.}

\item{lower}{Numeric scalar. Lower bound of the integration interval
(default = 1e-8 to avoid singularities at 0).}

\item{upper}{Numeric scalar. Upper bound of the integration interval
(default = 50).}

\item{max_attempts}{Integer. Maximum number of fallback attempts with
modified settings if the initial integration fails.}

\item{...}{Additional arguments passed to \code{integrand_func}.}
}
\value{
Numeric scalar. The estimated value of the integral, or 0 if all
  attempts fail.
}
\description{
Performs numerical integration with progressively more conservative
settings to improve robustness. Useful when standard integration
may fail due to oscillatory or heavy-tailed functions.
}
