% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.dendrogram.R
\name{get.dendrogram}
\alias{get.dendrogram}
\title{Dendrogram}
\usage{
get.dendrogram(
  population,
  path = NULL,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  method = NULL,
  individual.names = NULL
)
}
\arguments{
\item{population}{Population list}

\item{path}{provide a path if the dendrogram would be saved as a png-file}

\item{database}{Groups of individuals to consider}

\item{gen}{Quick-insert for database (vector of all generations to consider)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to consider)}

\item{id}{Individual IDs to search/collect in the database}

\item{method}{Method used to calculate genetic distances (default: "Nei", alt: "Rogers", "Prevosti", "Modified Rogers"}

\item{individual.names}{Names of the individuals in the database ((default are MoBPS internal names based on position))}
}
\value{
Dendrogram plot for genotypes
}
\description{
Function calculate a dendrogram
}
\examples{
data(ex_pop)
get.dendrogram(ex_pop, gen=2)
}
