% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pool.R
\name{get.pool}
\alias{get.pool}
\title{Export founder pool}
\usage{
get.pool(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  id = NULL,
  plot = FALSE,
  import.position.calculation = NULL,
  decodeOriginsU = decodeOriginsR,
  use.id = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{plot}{Set TRUE to generate a visualization of genetic origins}

\item{import.position.calculation}{Function to calculate recombination point into adjacent/following SNP}

\item{decodeOriginsU}{Used function for the decoding of genetic origins [[5]]/[[6]]}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}
}
\value{
Founder pool of in gen/database/cohorts selected individuals
}
\description{
Function to export founder pool
}
\examples{
data(ex_pop)
get.pool(ex_pop, gen=2)
}
