% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.variance.R
\name{get.variance}
\alias{get.variance}
\title{Derive variances components (add/dom)}
\usage{
get.variance(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  id = NULL
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}
}
\value{
Table with realized narrow/broad-sense heritability, sigma_g,a,d
}
\description{
Function to derive underlying variance components (add/dom)
}
\examples{
data(ex_pop)
get.variance(ex_pop, gen = 2)
}
