trans.armdataP <- function(study,treat,y,SE,data=NULL){

	data <- data.frame(data)

	study <- data[, deparse(substitute(study))]
	treat <- data[, deparse(substitute(treat))]
	y <- data[, deparse(substitute(y))]
	SE <- data[, deparse(substitute(SE))]

	study <- as.numeric(factor(study))

	trt <- treat

	treat <- levels(factor(trt))

	N <- max(study)
	p <- length(treat)
	
	L <- dim(data)[1]

	d <- n <- rep(NA,times=L)
	
	for(i in 1:L){
	
		yi <- y[i]
		vi <- SE[i]^2

		inve <- function(x){
		
			if((x[1]>0)&&(x[2]>0)&&(x[1]<x[2])){
	
				z0 <- x[1]/x[2]
				z1 <- z0 - yi
				z2 <- z0*(1-z0)/x[2] - vi
			
				return(c(z1,z2))
			
			}

			if((x[1]<=0)||(x[2]<=0)||(x[1]>x[2])){
	
				return(c(NaN,NaN))
			
			}
		
		}
		
		z0 <- c(10,100)
		d0 <- nleqslv(z0,inve)$x
		
		d[i] <- d0[1]
		n[i] <- d0[2]
	
	}
	
	Q1 <- data.frame(study,trt,d,n)
	
	message("Note that the estimated numbers of events and sample sizes may not correspond to the actual event counts and sample sizes.")
	message("They are solely working pseudo-data, designed so that the summary statistics generated by the setup function accord to the original data.")
	message("The NMA package tools rely solely on summary statistics for the synthesis analyses, so this is not problematic.")
	message("")

	return(Q1)

}
