% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{aba_phenotype_data_df}
\alias{aba_phenotype_data_df}
\title{Allen Brain Atlas Phenotype Data}
\format{
A data frame with 377 observations and 4 variables:
\describe{
  \item{structure_acronym.x}{Character: Brain structure acronym}
  \item{ihc_iba1_ffpe}{Numeric: IBA1 immunohistochemistry measurement (microglia marker)}
  \item{ihc_gfap_ffpe}{Numeric: GFAP immunohistochemistry measurement (astrocyte marker)}
  \item{id}{Character: Sample identification code}
}
}
\source{
Data taken from the BRETIGEA package version 1.0.3. Original data from:
Allen Brain Atlas Aging, Dementia, and TBI study.
}
\usage{
data(aba_phenotype_data_df)
}
\description{
This dataset, aba_phenotype_data_df, is a data frame containing brain tissue
phenotype measurements from the Allen Brain Atlas Aging, Dementia, and TBI study.
The data includes immunohistochemistry markers for microglia and astrocytes
across 377 brain samples, intended for correlation analyses with expression data.
}
\details{
The dataset name has been kept as 'aba_phenotype_data_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
