% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoSleepR.R
\name{nosleep_off}
\alias{nosleep_off}
\title{Turn nosleep off}
\usage{
nosleep_off(handle)
}
\arguments{
\item{handle}{Optional \code{"NoSleepR_handle"} object returned by
\code{nosleep_on()}. If omitted, all active nosleep handles created
in this session are turned off. Passing \code{NULL} is treated as a
no-op.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Turn off a specific nosleep request or, if no handle is supplied, every
active request opened by the current R session.
}
\examples{
\dontrun{
h <- nosleep_on()
# ... do work ...
nosleep_off(h)

# Equivalent shortcut to clear everything
nosleep_on()
nosleep_on()
nosleep_off()
}

}
