# PeruAPIs - Access Peruvian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# view_datasets_PeruAPIs

library(testthat)
library(PeruAPIs)

test_that("view_datasets_PeruAPIs works when package is loaded", {
  result <- view_datasets_PeruAPIs()
  expect_type(result, "character")
  expect_true(length(result) > 0)
})

test_that("view_datasets_PeruAPIs prints correct message", {
  output <- capture_messages(view_datasets_PeruAPIs())
  expect_match(
    output[1],
    "Datasets available in the 'PeruAPIs' package:",
    fixed = TRUE
  )
})

test_that("view_datasets_PeruAPIs returns expected datasets", {
  datasets <- view_datasets_PeruAPIs()
  expected_datasets <- c(
    "andean_migrants_health_df",
    "birds_peru_tbl_df",
    "iscd_education_tbl_df",
    "peru_blank_votes_df",
    "peru_coastline_df"



  )
  # Check if all expected datasets are present
  missing_datasets <- setdiff(expected_datasets, datasets)
  expect_true(
    length(missing_datasets) == 0,
    info = paste("Missing datasets:", paste(missing_datasets, collapse = ", "))
  )
})
