#' Package startup Message
#' @importFrom utils packageVersion
#' @noRd

QualityMeasureStartupMessage <- function()
{
  msg <- c(paste0(
    "This is QualityMeasure version ", packageVersion("QualityMeasure"), "."),
    "\n\nIf you have issues or feedback, please email me at nieser@stanford.edu, so I can make this package better!",
    "\n\nFor more info about this package, see https://github.com/knieser/quality_measure_reliability.")
  return(msg)
}

.onAttach <- function(lib, pkg)
{

  msg <- QualityMeasureStartupMessage()
  if(!interactive())
    msg[1] <- paste("Package 'QualityMeasure' version", packageVersion("QualityMeasure"))
  packageStartupMessage(msg)
  invisible()
}
