% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-KEGG-map.R
\name{plotKEGGMap}
\alias{plotKEGGMap}
\title{Plot KEGG map with DE genes}
\usage{
plotKEGGMap(
  DEResults,
  KEGGPathwayID,
  statistic = "logFC",
  useFDR = TRUE,
  pThreshold = 0.05,
  statLimit = 3
)
}
\arguments{
\item{DEResults}{A named list of data frame of DE analysis results.
The columns of each data frame should be at least ID, logFC, p.value and pFDR.}

\item{KEGGPathwayID}{The KEGG pathway ID.}

\item{statistic}{The column name of the statistic used to plot the DE genes.
If statistic is p.value or pFDR, all genes are colored.
Otherwise, only DE genes are colored.}

\item{useFDR}{If TRUE, DE genes are selected based on pFDR, otherwise p.value.}

\item{pThreshold}{The p-value threshold to select DE genes.
Only used when statistic is not p.value or pFDR.}

\item{statLimit}{The absolute value of the statistic to color the DE genes.
If statistic is p.value or pFDR, this parameter is the limit of -log10(p-value).
Otherwise, this parameter is the limit of the absolute value of the statistic.}
}
\value{
A list with the following elements:
\itemize{
\item plot: A ggplot object of the KEGG map.
\item width: The width of the KEGG map.
\item height: The height of the KEGG map.
}
}
\description{
This function plots KEGG map with DE genes.
}
\examples{
\donttest{
library(RCPA)
library(SummarizedExperiment)

affyDEExperiment <- loadData("affyDEExperiment")
agilDEExperiment <- loadData("agilDEExperiment")
RNASeqDEExperiment <- loadData("RNASeqDEExperiment")

DEResults <- list(
    "Affymetrix - GSE5281" = rowData(affyDEExperiment),
    "Agilent - GSE61196" = rowData(agilDEExperiment),
    "RNASeq - GSE153873" = rowData(RNASeqDEExperiment)
)

plotObj <- RCPA::plotKEGGMap(DEResults, "hsa05010", stat = "logFC", pThreshold = 1, statLimit = 1)

}
}
