% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analyses_functions_2.R
\name{cross_rate}
\alias{cross_rate}
\title{Crossing rate}
\usage{
cross_rate(X, A, subI = NULL, plot = FALSE)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence \eqn{t}
and the second one is the values of the time series \eqn{X(t)}.}

\item{A}{Constant level as a numeric value.}

\item{subI}{Time sub-interval as a vector, where the lower bound is
the first element and the upper bound is the second. Optional: If provided crossing rate
for the sub-interval is returned, otherwise the whole time interval is considered.}

\item{plot}{Logical: If \code{TRUE}, the time series, the constant level and crossing
points are plotted in interactive sessions.}
}
\value{
The crossing rate, which gives average number of crossings per time unit.
}
\description{
Computes the rate at which a time series crosses a specific
constant level for the provided time interval or its sub-interval.
}
\examples{
t <- seq(0, 1, length = 100)
TS <- data.frame("t" = t, "X(t)" = rnorm(100))
cross_rate(TS, 0.1, subI = c(0.2, 0.8), plot = TRUE)
}
\seealso{
\code{\link{cross_T}}, \code{\link{cross_mean}}
}
