% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots_sim_est.R
\name{plot.H_LFD}
\alias{plot.H_LFD}
\title{Plot the estimated Hurst functions and local fractal dimension estimates
for objects of class \code{H_LFD}}
\usage{
\method{plot}{H_LFD}(
  x,
  H_Est = TRUE,
  H_Smooth_Est = TRUE,
  LFD_Est = TRUE,
  LFD_Smooth_Est = TRUE,
  ...
)
}
\arguments{
\item{x}{Return from \code{\link{H_LFD}}.}

\item{H_Est}{Logical: If \code{TRUE}, the Hurst function estimated by using \code{\link{Hurst}} is plotted.}

\item{H_Smooth_Est}{Logical: If \code{TRUE}, the smoothed estimated Hurst function is plotted.
The estimated Hurst function is smoothed using the loess method.}

\item{LFD_Est}{Logical: If \code{TRUE}, the local fractal dimension estimates are plotted.}

\item{LFD_Smooth_Est}{Logical: If \code{TRUE}, the smoothed estimates of local fractal dimension is plotted.
Smoothed using the loess method.}

\item{...}{Other arguments.}
}
\value{
A ggplot object which is used to plot the time series with theoretical, raw and smoothed estimates of Hurst function
and raw and smoothed estimates of local fractal dimension.
}
\description{
Creates a plot of the user provided time series with the
Hurst function estimated using \code{\link{Hurst}}, the smoothed estimated
Hurst function and local fractal dimension estimated using \code{\link{LFD}}
and smoothed estimates of local fractal dimension for objects of class \code{"H_LFD"}.
}
\details{
Compared to \code{\link{plot_tsest}}, the function's argument is a \code{"H_LFD"}
object, not a time series.
}
\examples{
TS <- data.frame("t" = seq(0, 1, length = 1000), "X(t)" = rnorm(1000))
Object <- H_LFD(TS)
#Plot of time series, estimated and smoothed Hurst and LFD estimates
plot(Object)

}
\seealso{
\code{\link{H_LFD}}, \code{\link{Hurst}}, \code{\link{LFD}}, \code{\link{plot_tsest}}
}
