% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sanddollars.R
\docType{data}
\name{Sanddollars}
\alias{Sanddollars}
\title{Sand dollars}
\format{
A data frame with 36 rows (each experiment) and 4 columns:
\describe{
  \item{SD.temperatures}{The temperature, in degrees C, where the sand dollar is located}
  \item{SD.fertilization}{Sand dollar fertilization rates, in percent}
  \item{SD.speeds}{Sperm swimming velocities, in micrometres per second}
  \item{SD.motility}{Sperm motility}
}
}
\source{
Leuchtenberger, Sara Grace, Maris Daleo, Peter Gullickson, Andi Delgado, Carly Lo, and Michael T. Nishizaki. 2022. 
The Effects of Temperature and pH on the Reproductive Ecology of 
Sand Dollars and Sea Urchins: Impacts on Sperm Swimming and Fertilization. 
\emph{PLoS One} \bold{17} (12): e0276134

The data are available directly from:
Nishizaki, Michael T., Sara Grace Leuchtenberger, Maris Daleo,
Peter Gullickson, Andi Delgado, and Carly Lo. 2022. 
Echinoderm Sperm Swimming and Fertilization. 
\emph{Dryad}. <https://doi.org/10.5061/dryad.jwstqjqbz>
}
\usage{
data(Sanddollars)
}
\description{
Details about reproduction of sand dollars
}
\examples{
plot(SD.fertilization ~ SD.temperatures, 
     data = Sanddollars, 
     xlab = "Temperature (deg. C)", 
     ylab = "Fertilization rate (\%)")
}
\keyword{datasets}
