\name{SSAdecomp}
\alias{SSAdecomp}
\alias{print.SSAdecomp}

\title{
Singular Spectrum Analysis Decomposition For Time Series Data
}

\description{
Singular Spectrum Analysis (SSA) is an innovative time series analysis technique based on multivariate statistical principles.
It decomposes a time series into distinct additive components, including trends, periodic or quasi-periodic patterns, and residuals.
The function provides tools for decomposition and reconstruction, and the returned object can be further printed or summarized.
Optional verbose output is available to display correlation diagnostics during execution.
}

\usage{
SSAdecomp(data, L = 12, corr_thr = 0.97, horizon = 12, verbose = FALSE)
}

\arguments{
  \item{data}{Univariate time series data.}
  \item{L}{Integer, window length, multiple of periodicity of data series.}
  \item{corr_thr}{Numeric, threshold for correlation between the component pairs (default 0.97).}
  \item{horizon}{Integer, step ahead forecasting horizon.}
  \item{verbose}{Logical, if \code{TRUE}, prints messages with correlation diagnostics (default \code{FALSE}).}
}

\details{
SSA decomposes a time series into interpretable components such as trends, oscillations, and noise
without strict distributional and structural assumptions (Golyandina and Zhigljavsky, 2013).
It is widely used for trend identification, smoothing, seasonality extraction, and forecasting (Hassani et al., 2007).

The returned object is of class \code{"SSAdecomp"} and comes with a custom \code{print} method for user-friendly display.
}

\value{
An object of class \code{"SSAdecomp"} containing:
  \item{trend_component}{Reconstructed trend component of the time series.}
  \item{recon_components}{List of reconstructed seasonal and residual components from correlated groups.}
  \item{corr_pairs}{List of high correlation pairs with correlation values.}
}

\examples{
# Example using a sample time series
tsdata <- ts(rnorm(120), frequency = 12)
res <- SSAdecomp(data = tsdata, L = 12, corr_thr = 0.97, horizon = 12)

# Print summary
print(res)

# Show detailed correlation messages
res_verbose <- SSAdecomp(data = tsdata, L = 12, corr_thr = 0.97, horizon = 12, verbose = TRUE)
}



