% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussIndependent.R
\name{GaussIndependent}
\alias{GaussIndependent}
\alias{GaussRank}
\title{Linearly independent rows and columns by Gaussian elimination}
\usage{
GaussIndependent(
  x,
  printInc = FALSE,
  tolGauss = (.Machine$double.eps)^(1/2),
  testMaxInt = 0,
  allNumeric = FALSE
)

GaussRank(x, printInc = FALSE)
}
\arguments{
\item{x}{A (sparse) matrix}

\item{printInc}{Printing "..." to console when \code{TRUE}}

\item{tolGauss}{A tolerance parameter for sparse Gaussian elimination and linear dependency. This parameter is used only in cases where integer calculation cannot be used.}

\item{testMaxInt}{Parameter for testing: The Integer overflow situation will be forced when testMaxInt is exceeded}

\item{allNumeric}{Parameter for testing: All calculations use numeric algorithm (as integer overflow) when TRUE}
}
\value{
List of logical vectors specifying independent rows and columns
}
\description{
The function is written primarily for large sparse matrices with integers
and even more correctly it is primarily written for dummy matrices (0s and 1s in input matrix).
}
\details{
GaussRank returns the rank
}
\note{
The main algorithm is based on integers and exact calculations. When integers cannot be used (because of input or overflow), the algorithm switches.
With \code{printInc = TRUE} as a parameter, \code{.....} change to \verb{-----} when switching to numeric algorithm.
With numeric algorithm, a kind of tolerance for linear dependency is included.
This tolerance is designed having in mind that the input matrix is a dummy matrix.
}
\examples{

x <- ModelMatrix(SSBtoolsData("z2"), formula = ~fylke + kostragr * hovedint - 1)

GaussIndependent(x)
GaussRank(x)
GaussRank(Matrix::t(x))

\dontrun{
# For comparison, qr-based rank may not work
rankMatrix(x, method = "qr")

# Dense qr works 
qr(as.matrix(x))$rank
}
}
