% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_subgroup.R
\name{generate_subgroup}
\alias{generate_subgroup}
\alias{assumptions_subgroup}
\alias{true_summary_statistics_subgroup}
\alias{hazard_subgroup_from_PH_effect_size}
\alias{cen_rate_from_cen_prop_subgroup}
\title{Generate Dataset with different treatment effect in subgroup}
\usage{
generate_subgroup(condition, fixed_objects = NULL)

assumptions_subgroup(print = interactive())

true_summary_statistics_subgroup(
  Design,
  cutoff_stats = NULL,
  milestones = NULL,
  fixed_objects = NULL
)

hazard_subgroup_from_PH_effect_size(
  design,
  target_power_ph = NA_real_,
  final_events = NA_real_,
  target_alpha = 0.025
)

cen_rate_from_cen_prop_subgroup(design)
}
\arguments{
\item{condition}{condition row of Design dataset}

\item{fixed_objects}{additional settings, see details}

\item{print}{print code to generate parameter set?}

\item{Design}{Design data.frame for subgroup}

\item{cutoff_stats}{(optionally named) cutoff times, see details}

\item{milestones}{(optionally named) vector of times at which milestone survival should be calculated}

\item{design}{design data.frame}

\item{target_power_ph}{target power under proportional hazards}

\item{final_events}{target events for inversion of Schönfeld Formula, defaults to \code{condition$final_events}}

\item{target_alpha}{target one-sided alpha level for the power calculation}
}
\value{
For generate_subgroup: A dataset with the columns t (time) and trt
(1=treatment, 0=control), evt (event, currently TRUE for all observations)

For assumptions_subgroup: a design tibble with default values invisibly

For true_summary_statistics_subgroup: the design data.frame
passed as argument with the additional columns

For hazard_subgroup_from_PH_effect_size: the design data.frame passed as
argument with the additional columns hazard_trt and hazard_subgroup.

for cen_rate_from_cen_prop_subgroup: design data.frame with the
additional column random_withdrawal
}
\description{
Generate Dataset with different treatment effect in subgroup

Create an empty assumtions data.frame for generate_subgroup

Calculate true summary statistics for scenarios with differential treatment effect in subgroup

Calculate hazards in treatment arm in subgroup and compliment
}
\details{
Condidtion has to contain the following columns:
\itemize{
\item n_trt number of paitents in treatment arm
\item n_ctrl number of patients in control arm
\item hazard_ctrl hazard in the control arm
\item hazard_trt hazard in the treatment arm for not cured patients
\item hazard_subgroup hazard in the subgroup in the treatment arm
\item prevalence proportion of cured patients
}

assumptions_subgroup generates a default design \code{data.frame} for use
with generate_subgroup If print is \code{TRUE} code to produce the template is
also printed for copying, pasting and editing by the user. (This is the
default when run in an interactive session.)

\code{cutoff_stats} are the times used to calculate the statistics like average
hazard ratios and RMST, that are only calculated up to a certain point.

\code{hazard_subgroup_from_PH_effect_size} calculates the hazard rate in
the subgroup and the compliment of the subgroup in the treatment arm as
follows: First, the hazard ratio needed to archive the desired power under
proportional hazards is calculated by inverting Schönfeld's sample size
formula. Second the median survival times for both arms under this hazard
ratio and proportional hazards are calculated. Finally the hazard rate of
the treatment arm in the subgroup and its complement are set such that the
median survival time is the same as the one calculated under proportional
hazards.

This is a heuristic and to some extent arbitrary approach to calculate
hazard ratios that correspond to reasonable and realistic scenarios.

cen_rate_from_cen_prop_subgroup takes the proportion of
censored patients from the column \code{censoring_prop}. This column describes
the proportion of patients who are censored randomly before experiencing an
event, without regard to administrative censoring.
}
\section{Functions}{
\itemize{
\item \code{generate_subgroup()}: simulates a dataset with a mixture of cured
patients

\item \code{assumptions_subgroup()}: generate default assumptions \code{data.frame}

\item \code{true_summary_statistics_subgroup()}: calculate true summary statistics for subgroup

\item \code{hazard_subgroup_from_PH_effect_size()}: Calculate hazards in treatement arm

\item \code{cen_rate_from_cen_prop_subgroup()}: calculate censoring rate from censoring proportion

}}
\examples{
one_simulation <- merge(
    assumptions_subgroup(),
    design_fixed_followup(),
    by=NULL
  ) |>
  head(1) |>
  generate_subgroup()
head(one_simulation)
tail(one_simulation)
Design <- assumptions_subgroup()
Design
my_design <- merge(
    assumptions_subgroup(),
    design_fixed_followup(),
    by=NULL
  )
my_design <- true_summary_statistics_subgroup(my_design)
my_design

my_design <- merge(
  assumptions_subgroup(),
  design_fixed_followup(),
  by=NULL
)

my_design$hazard_trt <- NA
my_design$hazard_subgroup <- NA
my_design$hr_subgroup_relative <- 0.9
my_design$final_events <- ceiling((my_design$n_ctrl + my_design$n_trt) * 0.75)
my_design <- hazard_subgroup_from_PH_effect_size(my_design, target_power_ph=0.9)
my_design
design <- expand.grid(
  hazard_ctrl=0.2,                   # hazard under control and before treatment effect
  hazard_trt=0.02,                   # hazard after onset of treatment effect
  hazard_subgroup=0.01,              # hazard in the subgroup in treatment
  prevalence = c(0.2, 0.5),           # subgroup prevalence
  censoring_prop=c(0.1, 0.25, 0.01), # 10\%, 25\%, 1\% random censoring
  followup=100,                      # followup of 100 days
  n_trt=50,                          # 50 patients treatment
  n_ctrl=50                          # 50 patients control
)
cen_rate_from_cen_prop_subgroup(design)
}
