% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surprisal_analysis.R
\name{surprisal_analysis}
\alias{surprisal_analysis}
\title{This function performs surprisal analysis on transcriptomics data}
\usage{
surprisal_analysis(input.data, zero.handling = "pseudocount")
}
\arguments{
\item{input.data}{transcriptomics data stores as dataframe}

\item{zero.handling}{zero handling method. Can be either 'pseudocount' or
'log1p'. By default it is set to 'pseudocount'}
}
\value{
a list containing two matrix array objects, first one holding the
lambda values representing the constraints or Lagrange multipliers and the
second one holding the corresponding weights of transcripts stored (G matrix)
}
\description{
This function performs surprisal analysis on transcriptomics data
}
\examples{
expr.df <- data.frame(gene_id = paste0("Gene", 1:6),
S1 = c(0, 12, 3, 0, 50, 7),
S2 = c(5, 0, 2, 9, 0, 4),
S3 = c(8, 15, 0, 1, 25, 0),
S4 = c(0, 7, 6, 0, 40, 3),
check.names = FALSE)
surprisal_analysis(expr.df, zero.handling = "pseudocount")

}
