\name{SIMEX_AFT}
\alias{SIMEX_AFT}
\title{
SIMEX-based variable selection and network identification under AFT models
}
\description{
This function implements the SIMEX method for the penalized likelihood function to correct for measurement error effects, select informative covariates, and identify the network structure of covariates under accelerated failure time (AFT) models.
}
\usage{
SIMEX_AFT(surv, status, X, Sigma_e, Psi, K, dist, shape, scale, order)
}
\arguments{
  \item{surv}{An \eqn{n}-dimensional vector of observed times}
  \item{status}{An \eqn{n}-dimensional vector of censoring indicators}
  \item{X}{An \eqn{n \times p} matrix of the covariates, where \eqn{p} is greater than or equal to 2}
  \item{Sigma_e}{A \eqn{p \times p} positive definite covariance matrix}
  \item{Psi}{A user-specified sequence for generating synthetic data in the simulation step of the SIMEX method}
  \item{K}{A user-specified integer used for simulating data in the simulation step of the SIMEX method}
  \item{dist}{A user-specified distribution for the noise term in the AFT model. Options include Weibull distributions (\code{weibull}), exponential distributions (\code{exponential}), logistic distributions (\code{logistic}), and normal distributions (\code{normal}).}
  \item{shape}{A user-specified value for the shape parameter in the distribution (\code{dist}) }
  \item{scale}{A user-specified value for the scale parameter in the distribution (\code{dist}) }
  \item{order}{A positive integer (no smaller than 1) specifying the order of the polynomial functions used in the extrapolation step of the SIMEX method}

}


\details{
This function implements the SIMEX method to correct for measurement error effects and maximizes the penalized likelihood function under AFT models to perform variable selection, network detection, and estimation of the parameters.
}

\value{
\item{est_beta}{A \eqn{p}-dimensional vector of the estimators associated with the covariates}
\item{est_theta}{A \eqn{p \times p} matrix of the estimators associated with the pairwise interaction of covariates}
}

\references{
Chen, L.-P. and Yi, G. Y. (2021). Analysis of noisy survival data with graphical proportional hazards measurement error models. \emph{Biometrics}, 77, 956–969.
}

\author{
Chen, L.-P. and Yi, G. Y.
}



\examples{
library(MASS)
library(glmnet)
library(survival)
library(ahaz)
n = 200
p = 4
Z = mvrnorm(n,rep(0,p), diag(1,p))
T = exp(Z[,1]+Z[,2]+Z[,3]*Z[,4] + runif(n,0,1))
C = rexp(n,1)
Y = pmin(T,C)
delta = (T<C)*1
SA = diag(c(0,0.6,0,0.6),dim(Z)[2])
X = Z + mvrnorm(n,rep(0,p), SA)

est_AFT = SIMEX_AFT(Y, delta, X, Sigma_e = SA, Psi = seq(0,1,length=5), K=10,
 dist="weibull", shape=4, scale=2, order=2)
}

\keyword{funtion}
\keyword{core}
