% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wass_R2.R
\name{wass_R2}
\alias{wass_R2}
\title{Compute Wasserstein Coefficient of Determination}
\usage{
wass_R2(wass_regress_res)
}
\arguments{
\item{wass_regress_res}{an object returned by the \code{wass_regress} function}
}
\value{
Wasserstein \eqn{R^2}, the Wasserstein coefficient of determination
}
\description{
Compute Wasserstein Coefficient of Determination
}
\examples{
data(strokeCTdensity)
predictor = strokeCTdensity$predictors
dSup = strokeCTdensity$densitySupport
densityCurves = strokeCTdensity$densityCurve

res = wass_regress(rightside_formula = ~., Xfit_df = predictor,
Ymat = densityCurves, Ytype = 'density', Sup = dSup)
wass_r2 = wass_R2(res)
}
\references{
\cite{Frechet regression for random objects with Euclidean predictors, Alexander Petersen and Hans-Georg Müller, 2019}
}
