% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_gaucircles}
\alias{make_gaucircles}
\title{Generate Concentric Circles with a Gaussian Cluster in High Dimensions}
\usage{
make_gaucircles(
  n = c(200, 100, 100),
  p = 4,
  num_circles = 2,
  scale_circles = c(1, 2)
)
}
\arguments{
\item{n}{An integer vector of length \code{num_circles + 1}, giving the
number of points in each cluster (circles first, followed by the Gaussian).
Default is \code{c(200, 100, 100)}.}

\item{p}{Integer, the dimensionality of the embedding space. Must be at least 3.
Default is \code{4}.}

\item{num_circles}{Integer, the number of circular clusters to generate.
Default is \code{2}.}

\item{scale_circles}{Numeric vector of length \code{num_circles}, giving
the scale (radius) of each circular cluster. Default is \code{c(1, 2)}.}
}
\value{
A data frame (or tibble, depending on \code{gen_multicluster()})
  containing the generated dataset with cluster assignments.
}
\description{
This function generates a dataset consisting of multiple circular clusters
together with a single Gaussian cluster in a \eqn{p}-dimensional space.
The circles are placed concentrically at the origin with varying scales,
while the Gaussian cluster serves as an additional background or center cluster.
}
\examples{
# Two circles (radii 1 and 2) plus one Gaussian cluster in 4-D
gaucircles <- make_gaucircles()


}
