/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Imodule.h" 
#define H5I_TESTING    

#include "H5private.h"   
#include "H5CXprivate.h" 
#include "H5Eprivate.h"  
#include "H5Gprivate.h"  
#include "H5Ipkg.h"      

ssize_t
H5I__get_name_test(hid_t id, char *name , size_t size, bool *cached)
{
    H5VL_object_t *vol_obj;                       
    H5G_loc_t      loc;                           
    H5CX_node_t    api_ctx         = {{0}, NULL}; 
    bool           api_ctx_pushed  = false;       
    bool           vol_wrapper_set = false;       
    size_t         name_len        = 0;           
    ssize_t        ret_value       = -1;          

    FUNC_ENTER_PACKAGE

    
    if (H5CX_push(&api_ctx) < 0)
        HGOTO_ERROR(H5E_SYM, H5E_CANTSET, (-1), "can't set API context");
    api_ctx_pushed = true;

    
    if (NULL == (vol_obj = H5VL_vol_object(id)))
        HGOTO_ERROR(H5E_ID, H5E_BADTYPE, (-1), "invalid identifier");

    
    if (H5VL_set_vol_wrapper(vol_obj) < 0)
        HGOTO_ERROR(H5E_ID, H5E_CANTSET, (-1), "can't set VOL wrapper info");
    vol_wrapper_set = true;

    
    if (H5G_loc(id, &loc) < 0)
        HGOTO_ERROR(H5E_ID, H5E_CANTGET, (-1), "can't retrieve object location");

    
    if (H5G_get_name(&loc, name, size, &name_len, cached) < 0)
        HGOTO_ERROR(H5E_ID, H5E_CANTGET, (-1), "can't retrieve object name");

    
    ret_value = (ssize_t)name_len;

done:
    
    if (vol_wrapper_set && H5VL_reset_vol_wrapper() < 0)
        HDONE_ERROR(H5E_ID, H5E_CANTRESET, (-1), "can't reset VOL wrapper info");

    if (api_ctx_pushed && H5CX_pop(false) < 0)
        HDONE_ERROR(H5E_SYM, H5E_CANTRESET, (-1), "can't reset API context");

    FUNC_LEAVE_NOAPI(ret_value)
} 
