test_that("TPDDev returns correct structure", {
  d1 <- matrix(c(
     1,2,3,4,5,6,7,
     2,3,4,5,6,7,8,
     3,4,5,6,7,8,1,
     4,5,6,7,8,1,2,
     5,6,7,8,1,2,3,
     6,7,8,1,2,3,4,
     7,8,1,2,3,4,5,
     8,1,2,3,4,5,6
   ), nrow = 8, byrow = TRUE)
  base_d2 <- matrix(c(
     1,2,4,
     2,3,5,
     3,4,6,
     4,5,7,
     5,6,1,
     6,7,2,
     7,1,3
   ), ncol = 3, byrow = TRUE)
  result <- TPDDev(d1, base_d2)
  expect_true(is.list(result))
  expect_true(all(c("C_dir","C_res","C_int","efficiency_factor") %in% names(result)))
  expect_true(result$efficiency_factor > 0)
})
