% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConsistentSplits.R
\name{SplitConsistent}
\alias{SplitConsistent}
\alias{SplitConflicts}
\title{Identify consistent / conflicting splits}
\usage{
SplitConsistent(needle, haystack)

SplitConflicts(needle, haystack)
}
\arguments{
\item{needle}{Splits object containing the single split to evaluate}

\item{haystack}{Splits object, or list thereof, containing the splits to
compare against \code{needle}.}
}
\value{
\code{SplitConsistent()} returns a list of logical vectors.
Each list item corresponds to an entry in \code{haystack}, reporting whether each
split is consistent with (\code{TRUE}) or in conflict with (\code{FALSE}) \code{needle}.
\code{SplitConflicts()} returns the inverse.
}
\description{
\code{SplitConsistent()} and \code{SplitConflict()} determine whether a series of
splits \code{haystack} are consistent with or contradict the focal split \code{needle}.
}
\examples{
splits1 <- as.Splits(BalancedTree(8))
splits2 <- as.Splits(PectinateTree(8))
summary(splits1[[4]])
SplitConsistent(splits1[[4]], splits2)
SplitConflicts(splits1[[4]], list(splits1, splits2))
}
\seealso{
Other split manipulation functions: 
\code{\link{DropTip}()},
\code{\link{Subsplit}()},
\code{\link{TrivialSplits}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split manipulation functions}
