% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_uve.R
\name{season_uve}
\alias{season_uve}
\title{Seasonal erythemal UV}
\usage{
season_uve(
  data,
  date,
  longitude,
  latitude,
  temis_path = getwd(),
  season = "summer",
  type = "cumulative",
  region = "europe"
)
}
\arguments{
\item{data}{data frame containing sample IDs, date, longitude, and latitude}

\item{date}{A date vector, usually date of assessment or recruitment.}

\item{longitude}{A numeric vector of longitude values.}

\item{latitude}{A numeric vector of latitude values.}

\item{temis_path}{Path to TEMIS UV files downloaded using \link{temis_uvdec}. Default is current directory.}

\item{season}{The duration over which erythemal UV dose is to be estimated. One of "summer" covering April to September (default), "winter" covering October to March, or a numeric vector corresponding to month range.}

\item{type}{Type of annual dose to be calculated, cumulative (default) or mean.}

\item{region}{Region of TEMIS data required, options are "europe" (default) or "world".}
}
\value{
A numeric vector of mean or cumulative seasonal erythemal UV dose estimates.
}
\description{
This function estimates mean or cumulative erythemal UV dose over a period of months (<1 year) prior to an index date, at a given geographical location (longitude and latitude).
}
\examples{
#uses sample TEMIS file
mysample <- data.frame(id = c("id000016"),
        date = as.Date(c("2010-08-04")),
        longitude = c(-2.10),
        latitude = c(50.5))
uve_example <- system.file("extdata", "uve_example", package="UVdose")
season_uve(mysample, date, longitude, latitude, temis_path=uve_example, season = c(1:3,11:12))

season_uve(mysample, date, longitude, latitude, temis_path=uve_example, season = "summer")
}
