% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optparse_helper.R
\name{optparse_flag}
\alias{optparse_flag}
\title{optparse_flag - define a command parameter as a trigger}
\usage{
optparse_flag(help = "No documentation yet.", short = NULL, default = FALSE)
}
\arguments{
\item{help}{\itemize{
\item The help string to display when --help is triggered
}}

\item{short}{\itemize{
\item The shortcut fir this parameter. For example
for a --output param, we could use
\code{optparse_flag(short = "-o", ...)} to set the "-o" shortcut.
}}

\item{default}{\itemize{
\item The default value this parameter will hold.
}}
}
\value{
a list to give to \code{optparse_parameters} to build the
whole command line parsing tool.
}
\description{
To be used with \code{optparse_parameters}. This function tells
the provided parameter is a trigger (logical - TRUE/FALSE).
When the trigger parameter is not provided in the command line,
the value is FALSE. Otherwise, it is TRUE.
}
\examples{

str(optparse_parameters(
  a_parameter = optparse_flag(),
  args = list("--a-parameter")
))

}
\seealso{
\code{\link[=optparse_parameters]{optparse_parameters()}}
}
\author{
L.Pavot
}
