% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{format_pkncadata_intervals}
\alias{format_pkncadata_intervals}
\title{Create Dose Intervals Dataset}
\usage{
format_pkncadata_intervals(
  pknca_conc,
  pknca_dose,
  params = c("aucinf.obs", "aucint.last", "auclast", "cmax", "half.life", "tmax",
    "lambda.z", "lambda.z.n.points", "r.squared", "adj.r.squared", "lambda.z.time.first",
    "aucpext.obs", "aucpext.pred", "clast.obs", "cl.obs"),
  start_from_last_dose = TRUE
)
}
\arguments{
\item{pknca_conc}{A PKNCAdose object containing the concentration data.}

\item{pknca_dose}{A PKNCAdose object containing the dose data.}

\item{params}{A character vector specifying the pharmacokinetic parameters to include.}

\item{start_from_last_dose}{Logical defining if start is at time of last dose or C1.}
}
\value{
A data frame containing the dose intervals and specified pharmacokinetic parameters.
}
\description{
This function creates a dataset with dose intervals and specified pharmacokinetic parameters.
}
\details{
The function performs the following steps:
\itemize{
\item Creates a vector with all pharmacokinetic parameters.
\item Based on dose times, creates a data frame with start and end times.
\item If TRTRINT column is present in data, sets last dose end time to start + TRTRINT,
or if TRTRINT is NA then either Inf if only one dose present, or max end time if not.
\item If no TRTRINT column in data, sets last dose end time to the time of last sample
or Inf if single dose data.
\item Adds logical columns for each specified parameter.
}

Assumes that multiple dose data will have a TRTRINT column
or contain multiple doses in dataset
}
\examples{
adnca <- read.csv(system.file("shiny/data/Dummy_data.csv", package = "aNCA"))
pknca_data <- PKNCA_create_data_object(adnca)
pknca_conc <- pknca_data$conc
pknca_dose <- pknca_data$dose
params <- c("aucinf.obs", "cmax", "half.life", "tmax", "lambda.z")
dose_intervals <- format_pkncadata_intervals(pknca_conc, pknca_dose, params)

}
