% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_diam_to_sev_records.R
\name{derive_diam_to_sev_records}
\alias{derive_diam_to_sev_records}
\title{Creating Severity Records From Diameter}
\usage{
derive_diam_to_sev_records(
  dataset,
  filter_add = NULL,
  diam_code = "DIAMETER",
  faobj_values = c("REDNESS", "SWELLING"),
  testcd_sev = "SEV",
  test_sev = "Severity/Intensity",
  none = 0,
  mild = 2,
  mod = 5,
  sev = 10
)
}
\arguments{
\item{dataset}{Input data set

The variables \code{USUBJID},\code{FAOBJ},\code{AVAL}, \code{AVALC}, \code{FATESTCD} and \code{FATEST} are expected
for Input data set.}

\item{filter_add}{filter for the \code{dataset}.}

\item{diam_code}{Diameter record filter

\emph{Permitted Value}: A character vector or scalar.

Helps to filter the diameter records to derive the severity records by
passing the \code{FATESTCD} value for diameter which is corresponding to the
specified events in \code{faobj_values}.}

\item{faobj_values}{Event filter

\emph{Permitted Value}: A character vector or Scalar.

Helps to filter the events (\code{Redness} and \code{Swelling}) which has diameter records
to derive severity records by passing the events from \code{FAOBJ}.}

\item{testcd_sev}{To assign \code{FATESTCD} value for severity

\emph{Permitted Value}: A character scalar

Assign the value for \code{FATESTCD} variable to indicate the severity records.
Ignore the argument if you want to set the default value (\code{SEV}).}

\item{test_sev}{\code{FATEST} Value for severity

\emph{Permitted Value}: A Character scalar

Assign the value for \code{FATEST} variable to indicate the severity records.
Ignore the argument if you want to set the default value.}

\item{none}{Pass the lower limit for grade \code{"NONE"}

\emph{Permitted Value:} A numeric vector

The \code{none} and the following arguments (\code{mild}, \code{mode} and \code{sev}) will be
used for assigning the diameter limit to derive the \code{AVALC} (severity grade).

\emph{Assign the lower limit to derive the Severity Grade (\code{AVALC}).}\cr
\emph{For Example: User passing 0 to \code{none} and 2 to \code{mild}, 0 will act as lower limit and 2 will act}
\emph{as upper limit.}\cr

\emph{Note: Use the limit reference to pass the values to these arguments}\cr
\emph{Since the condition was coded like this,}\cr
\emph{NONE : \code{none} < AVAL <= \code{mild}}\cr
\emph{MILD : \code{mild} < AVAL <= \code{mod}}\cr
\emph{MODERATE : \code{mod} < AVAL <= \code{sev}}\cr
\emph{SEVERE : \code{sev} < AVAL}\cr
\emph{User should pass the values as numeric scalar. Refer the default values.}}

\item{mild}{Pass the lower limit for grade \code{"MILD"}

\emph{Permitted Value:} A numeric vector}

\item{mod}{Pass the lower limit for grade \code{"MODERATE"}

\emph{Permitted Value:} A numeric vector}

\item{sev}{Pass the lower limit for grade \code{"SEVERE"}

\emph{Permitted Value:} A numeric vector}
}
\value{
The Input data with the new severity records for Redness and swelling which
is specified in \code{faobj_values} and AVAL, AVALC will be derived and \code{FATESTCD},
\code{FATEST} will be changed as per the values.
}
\description{
To derive the severity records from the diameter records.
}
\note{
Basically, This function will derive and create the severity records from the
diameter record for the particular events specified in the \code{faobj_values} that user wants.
If you want to derive the Severity from diameter, even though you have the severity in SDTM data.
This function will re-derive the severity and remove the derived SDTM severity records.
}
\examples{
library(dplyr)
library(admiral)
library(tibble)

input <- tribble(
  ~USUBJID, ~FAOBJ, ~AVAL, ~AVALC, ~ATPTREF, ~FATEST, ~FATESTCD,
  "XYZ1001", "REDNESS", 7.5, "7.5", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "REDNESS", 3.5, "3.5", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "REDNESS", 2, "2", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "REDNESS", 1.8, "1.8", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "REDNESS", 1.4, "1.4", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1002", "REDNESS", 11.1, "11.1", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "REDNESS", 7.4, "7.4", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "REDNESS", 6, "6", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "REDNESS", 2.1, "2.1", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "REDNESS", 1.1, "1.1", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1001", "SWELLING", 5.5, "5.5", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "SWELLING", 2.5, "2.5", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "SWELLING", 2, "2", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "SWELLING", 1.8, "1.8", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1001", "SWELLING", 1.4, "1.4", "VACCINATION 1", "Diameter", "DIAMETER",
  "XYZ1002", "SWELLING", 10.1, "10.1", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "SWELLING", 7.1, "7.1", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "SWELLING", 5, "5", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "SWELLING", 1.8, "1.8", "VACCINATION 2", "Diameter", "DIAMETER",
  "XYZ1002", "SWELLING", 1.4, "1.4", "VACCINATION 2", "Diameter", "DIAMETER"
)

derive_diam_to_sev_records(
  dataset = input,
  faobj_values = c("REDNESS", "SWELLING"),
  diam_code = "DIAMETER",
  testcd_sev = "SEV",
  test_sev = "Severity"
)

}
\seealso{
Other der_rec: 
\code{\link{derive_fever_records}()}
}
\author{
Arjun Rubalingam
}
\concept{der_rec}
\keyword{der_rec}
