% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formating.R
\name{apa_format_columns}
\alias{apa_format_columns}
\title{Format data columns}
\usage{
apa_format_columns(
  data,
  column_formats = NULL,
  no_format_columns = NULL,
  rename_headers = TRUE,
  latex_headers = FALSE,
  format_separated_headers = TRUE,
  sep = "_",
  accuracy = NULL
)
}
\arguments{
\item{data}{data set (data.frame or tibble)}

\item{column_formats}{\code{column_formats} object. If NULL, the current default formatter set with \code{\link[=apa7_defaults]{apa7_defaults()}} will be used.}

\item{no_format_columns}{Column name or tidyselect function. selected columns are not formatted}

\item{rename_headers}{if \code{TRUE}, rename headers with markdown or latex}

\item{latex_headers}{if \code{TRUE}, rename headers with latex instead of markdown}

\item{format_separated_headers}{if \code{TRUE}, format headers with separated names. For example, if the formatter formats column \code{R2} as \verb{*R*^2^}, then \verb{Model 1_R2} becomes \verb{Model 1_*R*^2^})}

\item{sep}{separator for separated headers (default is "_")}

\item{accuracy}{numeric (default: NULL, uses the current default accuracy set with \code{\link[=apa7_defaults]{apa7_defaults()}}). If not NULL, sets the accuracy for the formatter.}
}
\value{
tibble
}
\description{
Format data columns
}
\examples{
lm(mpg ~ cyl + wt, data = mtcars) |>
  parameters::parameters() |>
  apa_format_columns() |>
  apa_flextable()
}
