% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debug.R
\name{argoFloatsDebug}
\alias{argoFloatsDebug}
\title{Print Debugging Information}
\usage{
argoFloatsDebug(
  debug = 0,
  ...,
  style = "plain",
  showTime = FALSE,
  unindent = 0
)
}
\arguments{
\item{debug}{an integer specifying the level of debugging. Values greater
than zero indicate that some printing should be done. Values greater
than 3 are trimmed to 3. Many functions pass \code{debug=debug-1} down to
deeper functions, which yields a nesting-indent format in the output.}

\item{...}{values to be printed, analogous to the \code{...} argument
list of \code{\link[=cat]{cat()}}.}

\item{style}{character value indicating special formatting, with \code{"plain"}
for normal text, \code{"bold"} for bold-faced text, \code{"italic"} for italicized
text, \code{"red"} for red text, \code{"green"} for green text, or \code{"blue"} for blue
text. These codes may not be combined.}

\item{showTime}{logical value indicating whether to preface message with
the present time. This can be useful for learning about which operations
are using the most time, but the default is not to show this, in the
interests of brevity.}

\item{unindent}{integer specifying the degree of reverse indentation
to be done, as explained in the \dQuote{Details} section.}
}
\value{
None (invisible NULL).
}
\description{
This function is intended mainly for use within the package, but users may
also call it directly in their own code.  Within the package, the value
of \code{debug} is generally reduced by 1 on each nested function call, leading
to indented messages. Most functions start and end with a call to
\code{\link[=argoFloatsDebug]{argoFloatsDebug()}} that has \code{style="bold"} and \code{unindent=1}.
}
\examples{
\donttest{
argoFloatsDebug(1, "plain text\n")
argoFloatsDebug(1, "red text\n", style = "red")
argoFloatsDebug(1, "blue text\n", style = "blue")
argoFloatsDebug(1, "bold text\n", style = "bold")
argoFloatsDebug(1, "italic text with time stamp\n", style = "italic", showTime = TRUE)
}
}
\author{
Dan Kelley
}
