% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_kr.R
\name{beta_kr}
\alias{beta_kr}
\title{Fit the K.R Model}
\usage{
beta_kr(data, M = 3, N, R, parallel_process = FALSE, seed = NULL)
}
\arguments{
\item{data}{A dataframe of dimension \eqn{C \times NR} containing methylation values for \eqn{C} CpG sites from \eqn{R} sample types collected from \eqn{N} patients.
Samples are grouped together in the dataframe such that the columns are ordered as Sample1_Patient1, Sample1_Patient2, Sample2_Patient1, Sample2_Patient2, etc.}

\item{M}{Number of methylation states to be identified.}

\item{N}{Number of patients in the study.}

\item{R}{Number of sample types collected from each patient for study.}

\item{parallel_process}{The "TRUE" option results in parallel processing of the models for increased computational efficiency. The default option has been set as "FALSE" due to package testing limitations.}

\item{seed}{Seed to allow for reproducibility (default = NULL).}
}
\value{
A list containing:
\itemize{
   \item cluster_size - The total number of CpG sites in each of the K clusters.
   \item llk - A vector containing the log-likelihood value at each step of the EM algorithm.
   \item alpha - The first shape parameter for the beta mixture model.
   \item delta - The second shape parameter for the beta mixture model.
   \item tau - The estimated mixing proportion for each cluster.
   \item z - A matrix of dimension \eqn{C \times K} containing the posterior probability of each CpG site belonging to each of the \eqn{K} clusters.
   \item classification - The classification corresponding to z, i.e. map(z).
   \item uncertainty - The uncertainty of each CpG site's clustering.
   \item DM - The AUC and WD metric for distribution similarity in each cluster. }
}
\description{
A beta mixture model for identifying differentially methylated CpG sites between \eqn{R} DNA sample types collected from \eqn{N} patients.
}
\details{
The K.R model allows identification of the differentially methylated CpG sites between the \eqn{R} DNA sample types collected from each of \eqn{N} patients.
As each CpG site in a DNA sample can belong to one of \eqn{M} methylation states, there can be \eqn{K=M^R} methylation state changes between \eqn{R} DNA sample types.
The shape parameters vary for each DNA sample type but are constrained to be equal for each patient. An initial clustering using k-means is performed to identify \eqn{K} clusters. The resulting clustering solution is provided as
starting values to the Expectation-Maximisation algorithm. A digamma approximation is used to obtain the maximised
parameters in the M-step.
}
\examples{
my.seed <- 190
M <- 3
N <- 4
R <- 2
data_output = beta_kr(pca.methylation.data[1:30,2:9], M, N, R,
                      parallel_process = FALSE, seed = my.seed)
}
\seealso{
\code{\link{betaclust}}
}
