% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databricks-dbplyr.R
\name{copy_to.DatabricksConnection}
\alias{copy_to.DatabricksConnection}
\title{Copy data frame to Databricks as table or view}
\usage{
\method{copy_to}{DatabricksConnection}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  temporary = TRUE,
  ...
)
}
\arguments{
\item{dest}{A DatabricksConnection object}

\item{df}{Data frame to copy}

\item{name}{Name for the table/view}

\item{overwrite}{Whether to overwrite existing table/view}

\item{temporary}{Whether to create as temporary view (default: TRUE, but NOT SUPPORTED - will error)}

\item{...}{Additional arguments passed to dbWriteTable}
}
\value{
dbplyr table reference
}
\description{
Copy data frame to Databricks as table or view
}
\details{
Note: temporary=TRUE will result in an error as temporary tables are not
supported with the SQL Statement Execution API. Use temporary=FALSE to create regular tables.
}
