% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pairwise.R
\name{plot_pairwise_linear}
\alias{plot_pairwise_linear}
\title{Pairwise plot in a linear layout}
\usage{
plot_pairwise_linear(
  scores,
  pair_order = "seriate_max",
  geom = c("point", "tile"),
  add_lines = FALSE,
  score_limits = NULL,
  na.value = "grey80",
  pal = "Blue-Red 3",
  interactive = FALSE
)
}
\arguments{
\item{scores}{A tibble with the calculated association measures for the  matrix plot.
Either of class \code{pairwise} or identical in structure to object of class \code{pairwise}.}

\item{pair_order}{The variable pair order to be used. The default NULL means pairs are in order of their first appearance in \code{scores}. A value of
"seriate_max" means pairs are in order of  maximum absolute scores. A value of "seriate_max_diff" means
pairs are in order of maximum scores difference.}

\item{geom}{The geom to be used. Should be "point" or "tile".}

\item{add_lines}{When geom= "point" is used, should the points be connected by lines? Defaults to FALSE.}

\item{score_limits}{a numeric vector of length specifying the limits of the scale.}

\item{na.value}{used for geom_tile with a value of NA}

\item{pal}{For geom="title" only. If provided, should name a one of the sequential or diverging palettes from package colorspace.
See \code{\link[colorspace:hcl_palettes]{colorspace::hcl_palettes()}}. Otherwise defaults to a blue-red scheme.}

\item{interactive}{defaults to FALSE}
}
\value{
A \code{girafe} object if interactive==TRUE, otherwise a \code{ggplot2}.
}
\description{
Plots the calculated measures of association among different variable pairs for a dataset in a linear layout.
}
\examples{
plot_pairwise_linear(pairwise_scores(iris))
plot_pairwise_linear(pairwise_scores(iris,by="Species"))
plot_pairwise_linear(pairwise_multi(iris), geom="tile")
}
