% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{normTable}
\alias{normTable}
\title{Create a norm table based on model for specific age}
\usage{
normTable(
  A,
  model,
  minNorm = NULL,
  maxNorm = NULL,
  minRaw = NULL,
  maxRaw = NULL,
  step = NULL,
  monotonuous = TRUE,
  CI = 0.9,
  reliability = NULL,
  pretty = T
)
}
\arguments{
\item{A}{the age as single value or a vector of age values}

\item{model}{The regression model from the cnorm function}

\item{minNorm}{The lower bound of the norm score range}

\item{maxNorm}{The upper bound of the norm score range}

\item{minRaw}{clipping parameter for the lower bound of raw scores}

\item{maxRaw}{clipping parameter for the upper bound of raw scores}

\item{step}{Stepping parameter with lower values indicating higher precision}

\item{monotonuous}{corrects for decreasing norm scores in case of model inconsistencies (default)}

\item{CI}{confidence coefficient, ranging from 0 to 1, default .9}

\item{reliability}{coefficient, ranging between  0 to 1}

\item{pretty}{Format table by collapsing intervals and rounding to meaningful precision}
}
\value{
either data.frame with norm scores, predicted raw scores and percentiles in case of simple A
value or a list #' of norm tables if vector of A values was provided
}
\description{
This function generates a norm table for a specific age based on the regression
model by assigning raw scores to norm scores. Please specify the
range of norm scores, you want to cover. A T value of 25 corresponds to a percentile
of .6. As a consequence, specifying a range of T = 25 to T = 75 would cover 98.4 % of
the population. Please be careful when extrapolating vertically (at the lower and
upper end of the age specific distribution). Depending on the size of your standardization
sample, extreme values with T < 20 or T > 80 might lead to inconsistent results.
In case a confidence coefficient (CI, default .9) and the reliability is specified,
confidence intervals are computed for the true score estimates, including a correction for
regression to the mean (Eid & Schmidt, 2012, p. 272).
}
\examples{
# Generate cnorm object from example data
cnorm.elfe <- cnorm(raw = elfe$raw, group = elfe$group)

# create single norm table
norms <- normTable(3.5, cnorm.elfe, minNorm = 25, maxNorm = 75, step = 0.5)

# create list of norm tables
norms <- normTable(c(2.5, 3.5, 4.5), cnorm.elfe,
  minNorm = 25, maxNorm = 75,
  step = 1, minRaw = 0, maxRaw = 26
)

# conventional norming, set age to arbitrary value
model <- cnorm(raw=elfe$raw)
normTable(0, model)

}
\references{
Eid, M. & Schmidt, K. (2012). Testtheorie und Testkonstruktion. Hogrefe.
}
\seealso{
rawTable

Other predict: 
\code{\link{derivationTable}()},
\code{\link{getNormCurve}()},
\code{\link{predict.cnormBetaBinomial}()},
\code{\link{predict.cnormBetaBinomial2}()},
\code{\link{predict.cnormShash}()},
\code{\link{predictNorm}()},
\code{\link{predictRaw}()},
\code{\link{rawTable}()}
}
\concept{predict}
